// List.cpp: implementation of the List class.
//
//////////////////////////////////////////////////////////////////////

#include <assert.h>
#include "List.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

template <class T>

//Default Constructor

List<T>::List()
{
	Head=NULL;
	Tail=NULL;
	size=0;
}

template <class T>

//Destructor

List<T>::~List()
{
	Delete_List();
	size=0;
}

template <class T>

//Returns the size of the list

int List<T> :: Get_size() const
{
	return size;
}

template <class T>

//Returns the Customer at the front of the List

T List<T> :: Get_Customer()
{
	if (Head->next!=NULL)
	{
		Node<T>* current=Head;
		Head=Head->next;
		size--;
		
		return current->data;	
	}
	return 0 ;
}

template <class T>

//Checks that the desired customer is in the list or not

bool List<T> :: Check_Customer(T& value)
{
	Node<T>* current=Head;

	while(current!=NULL)
	{
		if (current->data==value)
			return false;

		current=current->next;
	}
	return true;
}

template <class T>

//Deletes the entire list

void List<T>::Delete_List()
{
	if (Head!=NULL)
	{
		Node<T> *currentptr=Head;
		Node<T> *tempptr;

		while (currentptr!=0)
		{
			tempptr=currentptr;
			currentptr=currentptr->next;			
			delete tempptr;
		}
	}	

	Head=NULL;
}

template <class T>

//Inserts a new node in the list 

void List<T> :: Insert_Node(const T & d)
{
	Node<T> *newptr=new Node<T>(d);
	assert(newptr!=NULL);

	if (Head==0)
	{
		Head=newptr;
		Tail=newptr;
	}
	else
	{
		Tail->next=newptr;
		Tail=newptr;
	}
	size++;
}

template <class T>

//Inserts a new node in the front of the list 

void List<T> :: Insert_At_Front(const T & d)
{
	Node<T> *newptr=new Node<T>(d);
	assert(newptr!=NULL);

	if (Head==0)
	{
		Head=newptr;
		Tail=newptr;
	}
	else
	{
		newptr->next=Head;
		Head=newptr;
	}
	size++;
}

template <class T>

//Delete a node from the list after the matching of the data

void List<T> :: Delete_Node(const T &d)
{
	if (Head==0)
	{
		cout<<"\n error : THE LIST IS EMPTY !";
	}
	else
	{
		Node<T> *Fatherptr=Head;
		Node<T> *Sonptr=Head->next;

		if (Fatherptr->data==d)
		{
			Head=Head->next;
		}
		else
		{
			while (Sonptr!=NULL)
			{
				if (Sonptr->data==d)
				{
					Fatherptr->next=Sonptr->next;
				}	

				Sonptr=Sonptr->next;
				Fatherptr=Fatherptr->next;
			}
		}
	}
}

template <class T>

//Displays the entire list

void List<T> :: Display_List(char* str , ostream &outFile) const 
{
	if (Head==0)
		outFile<<"error : THE LIST IS EMPTY ! \n";

	else
	{
		Node<T> *currentptr=Head;

		outFile<<"\n\n -------------------------------------------";
		outFile<<"\n\t"<<str;
		outFile<<"\n -------------------------------------------\n";		

		while (currentptr !=NULL)
		{
			outFile<<"\t\t"<<currentptr->data<<endl<<endl;
			currentptr=currentptr->next;
		}		
	}
}

template <class T>

//Copy Constructor

List<T> :: List(const List<T> &original)
{
	size=original.size;

	Node<T> *ptr=original.Head;
	Node<T> *newptr , *lastptr;

	while(ptr!=NULL);
	{
		newptr=new Node<T>(ptr->data);
		assert(newptr!=0);

		if (Head==0)
			Head=newptr;
		else
			lastptr->next=newptr;

		lastptr=newptr;
		ptr=ptr->next;
	}
}

template <class T>

//Assigment Operator

List<T>& List<T> :: operator=(const List<T> &original)
{
	size=original.size;

	Node<T> *ptr=original.Head;
	Node<T> *newptr , *lastptr;

	while(ptr!=NULL)
	{
		newptr=new Node<T>(ptr->data);
		assert(newptr!=0);

		if (Head==0)
			Head=newptr;
		else
			lastptr->next=newptr;

		lastptr=newptr;
		ptr=ptr->next;
	}	
	return (*this);
}
